import { Component, OnInit, Input } from '@angular/core';
import { MvpServices } from '../../../../services/mvp-services';
import { NgRedux, select } from 'ng2-redux';

@Component({
  selector: 'app-mvp-add-alt-definitions',
  templateUrl: './mvp-add-alt-definitions.component.html',
  styleUrls: ['./mvp-add-alt-definitions.component.scss']
})
export class MvpAddAltDefinitionsComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
	@Input() mvpObject;
	@Input() altDefinition;
  @select(['system', 'focusedElement']) focusedElement;
  onHoverSubmit: boolean;

  constructor(
  	public mvpServices: MvpServices) { }

  ngOnInit() {
  }

  addAltDefinitionToMvpObject(){
    var altDefinitionInput;
    if (this.altDefinition != null && this.altDefinition.length > 0) {
      altDefinitionInput = this.altDefinition.trim();
    }
    if (altDefinitionInput != null && altDefinitionInput.length > 0) {
      this.mvpObject.object = altDefinitionInput;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
